// controllers/wallet.controller.js
const Wallet = require("../models/Wallet");

console.log("✅ Wallet Controller loaded");

exports.getWallet = async (req, res) => {
  try {
    console.log("📥 getWallet called for user:", req.user?.id);
    
    const wallet = await Wallet.findOne({ userId: req.user.id });

    if (!wallet) {
      console.log("❌ Wallet not found");
      return res.status(404).json({ message: "Wallet not found" });
    }

    console.log("✅ Wallet found:", wallet);

    res.json({
      balance: wallet.balance,
      currency: wallet.currency,
      status: wallet.status
    });

  } catch (err) {
    console.error("❌ Error in getWallet:", err);
    res.status(500).json({ message: "Server error" });
  }
};