// models/Payment.js
const mongoose = require("mongoose");

const paymentSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    clientTxnId: {
      type: String,
      required: true,
      unique: true,
      index: true,
    },
    amount: {
      type: Number,
      required: true,
    },
    productInfo: {
      type: String,
      required: true,
    },
    customerName: {
      type: String,
      required: true,
    },
    customerEmail: {
      type: String,
      required: true,
    },
    customerMobile: {
      type: String,
      required: true,
    },
    redirectUrl: {
      type: String,
    },
    upiIdHash: {
      type: String,
    },
    upiIntent: {
      bhimLink: String,
      phonepeLink: String,
      paytmLink: String,
    },
    status: {
      type: String,
      enum: [
        "PENDING",      // Initial state
        "created",      // ✅ Gateway sends this when order created
        "SUCCESS",      // Payment successful
        "success",      // ✅ Gateway might send lowercase
        "FAILED",       // Payment failed
        "failed",       // ✅ Gateway might send lowercase
        "EXPIRED",      // Payment expired
        "expired"       // ✅ Gateway might send lowercase
      ],
      default: "PENDING",
      index: true,
    },
    gatewayTxnId: {
      type: String,
    },
    utr: {
      type: String, // ✅ Add UTR field for successful payments
    },
    udf1: String,
    udf2: String,
    udf3: String,
    gatewayResponse: {
      type: mongoose.Schema.Types.Mixed,
    },
    webhookData: {
      type: mongoose.Schema.Types.Mixed,
    },
    callbackResponse: {
      type: mongoose.Schema.Types.Mixed,
    },
    paidAt: {
      type: Date,
    },
      // ✅ Add this field to track wallet update
  walletUpdated: {
    type: Boolean,
    default: false
  },
 txnDate: {
  type: String,
  required: true,
  index: true
}


  },
  {
    timestamps: true,
  }
);

// Compound index for faster queries
paymentSchema.index({ userId: 1, status: 1 });
paymentSchema.index({ createdAt: -1 });

module.exports = mongoose.model("Payment", paymentSchema);