const mongoose = require("mongoose");

const userSchema = new mongoose.Schema(
  {
    name: { type: String, required: true },

    email: {
      type: String,
      required: true,
      unique: true,
      lowercase: true,
      index: true
    },

    mobile: {
      type: String,
      required: true,
      unique: true
    },

    password: {
      type: String,
      required: true,
      select: false // 🔐 security
    },

    // 🔗 Wallet reference
    wallet: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Wallet"
    },

    resetPasswordToken: String,
    resetPasswordExpires: Date,

    isActive: {
      type: Boolean,
      default: true
    },

    memberAccount: {
      type: String,
      unique: true,
      sparse: true
    }
  },
  { timestamps: true }
);

module.exports = mongoose.model("User", userSchema);
