// models/WalletTransaction.js
const mongoose = require("mongoose");

const walletTransactionSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "User",
    required: true,
    index: true
  },

  walletId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Wallet",
    required: true
  },

  amount: {
    type: Number,
    required: true
  },

  type: {
    type: String,
    enum: ["credit", "debit"],
    required: true
  },

  reason: {
    type: String,
    enum: [
      "ADD_MONEY",
      "GAME_PLAY",
      "GAME_WIN",
      "REFUND",
      "ADMIN_ADJUST"
    ],
    required: true
  },

  status: {
    type: String,
    enum: ["success", "failed", "pending"],
    default: "success"
  },

  paymentGateway: {
    type: String,
    default: "UPI"
  },

  referenceId: {
    type: String // payment.clientTxnId / gameId
  },

  balanceBefore: Number,
  balanceAfter: Number

}, { timestamps: true });


module.exports = mongoose.model("WalletTransaction", walletTransactionSchema);
