// routes/payment.routes.js
const express = require("express");
const router = express.Router();
const auth = require("../middleware/auth.middleware");
const paymentController = require("../controllers/payment.controller");

// Create payment order
router.post("/create-order", auth, paymentController.createPaymentOrder);

// Check payment status
router.get("/status/:clientTxnId", paymentController.checkPaymentStatus);

// Webhook endpoint (called by UPI Gateway)
router.post("/webhook", paymentController.handleWebhook);

// Get payment details
router.get("/details/:clientTxnId", paymentController.getPaymentDetails);

// Get user payment history (optional but useful)
router.get("/user/:userId", paymentController.getUserPayments);

module.exports = router;