const Wallet = require("../models/Wallet");
const WalletTransaction = require("../models/WalletTransaction");
const User = require("../models/User");

const creditWallet = async ({ payment }) => {
  if (!payment) return;

  if (payment.walletUpdated) {
    console.log("⚠️ Wallet already updated for:", payment.clientTxnId);
    return;
  }

  // 🔎 Find wallet
  let wallet = await Wallet.findOne({ userId: payment.userId });

  // 🆕 AUTO CREATE WALLET (THIS WAS MISSING)
  if (!wallet) {
    wallet = await Wallet.create({
      userId: payment.userId,
      balance: 0,
      currency: "INR",
      status: "active"
    });

    // 🔗 Attach wallet to user
    await User.findByIdAndUpdate(payment.userId, {
      wallet: wallet._id
    });

    console.log("🆕 Wallet auto-created for user:", payment.userId);
  }

  const balanceBefore = Number(wallet.balance);
  const amount = Number(payment.amount);
  const balanceAfter = balanceBefore + amount;

  wallet.balance = balanceAfter;
  await wallet.save();

  await WalletTransaction.create({
    userId: payment.userId,
    walletId: wallet._id,
    amount,
    type: "credit",
    reason: "ADD_MONEY",
    status: "success",
    paymentGateway: "UPI",
    referenceId: payment.clientTxnId,
    balanceBefore,
    balanceAfter
  });

  payment.walletUpdated = true;
  await payment.save();

  console.log(
    `💰 Wallet credited: ${balanceBefore} → ${balanceAfter} (Txn: ${payment.clientTxnId})`
  );
};

module.exports = { creditWallet };
